/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.config.MutantMoreGroupedOptionsCommonConfig;
import com.alexander.mutantmore.config.MutantShulkerTurretCommonConfig;
import com.alexander.mutantmore.entities.CustomShulkerBullet;
import com.alexander.mutantmore.entities.MutantShulker;
import com.alexander.mutantmore.entities.MutantShulkerBullet;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.interfaces.IHasCustomExplosion;
import com.alexander.mutantmore.util.MiscUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantShulkerTurret
extends AbstractGolem
implements IAnimatable,
IAnimationTickable,
IHasCustomExplosion {
    private static final EntityDataAccessor<Integer> TOP_HEAD_TARGET = SynchedEntityData.m_135353_(MutantShulkerTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MID_HEAD_TARGET = SynchedEntityData.m_135353_(MutantShulkerTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_DEPLOY = SynchedEntityData.m_135353_(MutantShulkerTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int deployAnimationTick;
    public int deployAnimationLength = 65;
    public int topSegmentShootAnimationTick;
    public int midSegmentShootAnimationTick;
    public int bottomSegmentShootAnimationTick;
    public int shootAnimationLength = 22;
    public int shootAnimationActionPoint = 5;
    public float topHeadXRot;
    public float topHeadYRot;
    public float midHeadXRot;
    public float midHeadYRot;
    public int topHeadLoseTargetTime;
    public int midHeadLoseTargetTime;
    public int topHeadShootCooldown;
    public int midHeadShootCooldown;
    public int shulkerBulletShootCooldownLength = 60;
    public float topHeadRandomLookY;
    public float midHeadRandomLookY;
    private final Predicate<LivingEntity> TARGETING_PREDICATE = target -> (target instanceof Enemy || target.m_6095_().m_204039_(TagInit.EntityTypes.MUTANT_SHULKER_TURRET_TARGETS)) && target.m_5789_() && this.m_6779_((LivingEntity)target);
    private final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(((Double)MutantShulkerTurretCommonConfig.follow_range.get()).doubleValue()).m_26888_(this.TARGETING_PREDICATE);

    public MutantShulkerTurret(EntityType<? extends MutantShulkerTurret> p_i50189_1_, Level p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.shulkerBulletShootCooldownLength = (Integer)MutantShulkerTurretCommonConfig.shoot_cooldown.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 20, false, false, entity -> entity instanceof Enemy || entity.m_6095_().m_204039_(TagInit.EntityTypes.MUTANT_SHULKER_TURRET_TARGETS)));
    }

    public boolean m_6779_(LivingEntity target) {
        if (target.m_21023_(MobEffects.f_19620_) && ((Boolean)MutantShulkerTurretCommonConfig.ignores_levitating_mobs.get()).booleanValue()) {
            return false;
        }
        return this.canTarget((Entity)target) && super.m_6779_(target);
    }

    @Override
    public boolean canHarmWithExplosion(Entity target) {
        if ((!(target instanceof Enemy) || target.m_6095_().m_204039_(TagInit.EntityTypes.MUTANT_SHULKER_TARGETS)) && this.m_5647_() == null && target.m_5647_() == null) {
            return (Boolean)MutantShulkerTurretCommonConfig.friendly_fire.get() != false && (Boolean)MutantMoreGroupedOptionsCommonConfig.friendly_fire_on.get() == false;
        }
        return this.explosionCanHarm(target);
    }

    boolean explosionCanHarm(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TURRET_MUTANT_SHULKER_BULLET_CANT_HURT, (Entity)this, target, (Entity)this, null);
    }

    boolean canTarget(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TURRET_CANT_TARGET, (Entity)this, target, (Entity)this, null);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.05).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setConfigurableAttributeValues() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)MutantShulkerTurretCommonConfig.max_health.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)MutantShulkerTurretCommonConfig.armour.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)MutantShulkerTurretCommonConfig.armour_toughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)MutantShulkerTurretCommonConfig.knockback_resistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)MutantShulkerTurretCommonConfig.follow_range.get()).doubleValue());
        this.m_21153_(this.m_21233_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        this.setConfigurableAttributeValues();
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    protected BodyRotationControl m_7560_() {
        return new MutantShulkerTurretBodyRotationControl((Mob)this);
    }

    public boolean shouldBodyMoveWithHead() {
        return false;
    }

    public int m_8085_() {
        return Integer.MAX_VALUE;
    }

    public int m_8132_() {
        return Integer.MAX_VALUE;
    }

    public boolean m_6469_(DamageSource p_28848_, float p_28849_) {
        Crackiness crackiness = this.getCrackiness();
        boolean flag = super.m_6469_(p_28848_, p_28849_);
        if (flag && this.getCrackiness() != crackiness) {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_TURRET_CRACK.get(), 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    protected InteractionResult m_6071_(Player p_28861_, InteractionHand p_28862_) {
        ItemStack itemstack = p_28861_.m_21120_(p_28862_);
        if (itemstack.m_204117_(TagInit.Items.REPAIRS_MUTANT_SHULKER_TURRET) && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(this.m_21233_() * (((Integer)MutantShulkerTurretCommonConfig.repair_heal_percent.get()).floatValue() / 100.0f));
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_TURRET_REPAIR.get(), 1.0f, f1);
            if (!p_28861_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_28861_, p_28862_);
    }

    public void m_20256_(Vec3 vec) {
        super.m_20256_(new Vec3((Boolean)MutantShulkerTurretCommonConfig.locked_horizontal_movement.get() != false ? 0.0 : vec.f_82479_, vec.f_82480_, (Boolean)MutantShulkerTurretCommonConfig.locked_horizontal_movement.get() != false ? 0.0 : vec.f_82481_));
    }

    protected SoundEvent m_7515_() {
        return this.deployAnimationTick > 0 ? null : (SoundEvent)SoundEventInit.MUTANT_SHULKER_TURRET_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_27517_) {
        return (SoundEvent)SoundEventInit.MUTANT_SHULKER_TURRET_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventInit.MUTANT_SHULKER_TURRET_DEATH.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOULD_DEPLOY, (Object)true);
        this.f_19804_.m_135372_(MID_HEAD_TARGET, (Object)0);
        this.f_19804_.m_135372_(TOP_HEAD_TARGET, (Object)0);
    }

    public boolean shouldDeploy() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_DEPLOY);
    }

    public void setShouldDeploy(boolean setTo) {
        this.f_19804_.m_135381_(SHOULD_DEPLOY, (Object)setTo);
    }

    public int getMidHeadTargetID() {
        return (Integer)this.f_19804_.m_135370_(MID_HEAD_TARGET);
    }

    public void setMidHeadTargetID(int setTo) {
        this.f_19804_.m_135381_(MID_HEAD_TARGET, (Object)setTo);
    }

    public int getTopHeadTargetID() {
        return (Integer)this.f_19804_.m_135370_(TOP_HEAD_TARGET);
    }

    public void setTopHeadTargetID(int setTo) {
        this.f_19804_.m_135381_(TOP_HEAD_TARGET, (Object)setTo);
    }

    public Entity getTopHeadTarget() {
        return this.getTopHeadTargetID() == 0 ? null : this.f_19853_.m_6815_(this.getTopHeadTargetID());
    }

    public Entity getMidHeadTarget() {
        return this.getMidHeadTargetID() == 0 ? null : this.f_19853_.m_6815_(this.getMidHeadTargetID());
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return !this.m_21224_() && !this.m_213877_();
    }

    public boolean m_142535_(float p_149589_, float p_149590_, DamageSource p_149591_) {
        return false;
    }

    public boolean m_147207_(MobEffectInstance p_182397_, @Nullable Entity p_182398_) {
        return false;
    }

    public void m_5997_(double p_20286_, double p_20287_, double p_20288_) {
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 0.9f;
    }

    public float getMidHeadEyeHeight() {
        return 2.5f;
    }

    public float getTopHeadEyeHeight() {
        return 3.75f;
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (!this.f_19853_.f_46443_ && this.m_5448_() != null && this.m_5448_().m_21023_(MobEffects.f_19620_)) {
            this.m_6710_(null);
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
        if (this.topHeadShootCooldown > 0) {
            --this.topHeadShootCooldown;
        }
        if (this.midHeadShootCooldown > 0) {
            --this.midHeadShootCooldown;
        }
        if (this.shouldDeploy()) {
            this.deployAnimationTick = this.deployAnimationLength;
            this.setShouldDeploy(false);
            this.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_TURRET_DEPLOY.get());
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_217043_().m_188501_() < 0.02f) {
            this.topHeadYRot = this.f_19796_.m_188501_() * 360.0f;
        }
        if (this.m_217043_().m_188501_() < 0.02f) {
            this.midHeadYRot = this.f_19796_.m_188501_() * 360.0f;
        }
        if (this.deployAnimationTick <= 0) {
            CustomShulkerBullet shulkerBullet;
            float f1;
            float f;
            double d7;
            double d6;
            double d5;
            double d4;
            double d3;
            double d1;
            List viableTargets;
            if (this.getTopHeadTarget() == null) {
                this.topHeadXRot = this.rotlerp(this.topHeadXRot, 0.0f, 10.0f);
                this.topHeadYRot = this.rotlerp(this.topHeadYRot, this.f_20883_, 10.0f);
                if (!this.f_19853_.f_46443_ && !(viableTargets = this.f_19853_.m_45971_(Mob.class, this.TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(this.m_21133_(Attributes.f_22277_), 6.0, this.m_21133_(Attributes.f_22277_)))).isEmpty() && this.f_19796_.m_188503_(20) == 0) {
                    this.topHeadLoseTargetTime = 60;
                    this.setTopHeadTargetID(((Mob)viableTargets.get(this.f_19796_.m_188503_(viableTargets.size()))).m_19879_());
                }
            } else {
                double d9 = this.m_20185_();
                d1 = this.m_20186_() + (double)this.getTopHeadEyeHeight();
                d3 = this.m_20189_();
                d4 = this.getTopHeadTarget().m_20185_() - d9;
                d5 = this.getTopHeadTarget().m_20188_() - d1;
                d6 = this.getTopHeadTarget().m_20189_() - d3;
                d7 = Math.sqrt(d4 * d4 + d6 * d6);
                f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                f1 = (float)(-(Mth.m_14136_((double)d5, (double)d7) * 57.2957763671875));
                this.topHeadXRot = this.rotlerp(this.topHeadXRot, f1, 40.0f);
                this.topHeadYRot = this.rotlerp(this.topHeadYRot, f, 10.0f);
                if (!this.f_19853_.f_46443_) {
                    if (this.topHeadShootCooldown <= 0) {
                        this.topHeadShootCooldown = this.shulkerBulletShootCooldownLength;
                        this.topSegmentShootAnimationTick = this.shootAnimationLength;
                        this.f_19853_.m_7605_((Entity)this, (byte)4);
                    }
                    if (this.topSegmentShootAnimationTick == this.shootAnimationActionPoint) {
                        shulkerBullet = new CustomShulkerBullet(this.f_19853_, (LivingEntity)this, this.getTopHeadTarget(), Direction.Axis.Y);
                        shulkerBullet.damage = ((Double)MutantShulkerTurretCommonConfig.shulker_bullet_damage.get()).floatValue();
                        shulkerBullet.levitationLength = (Integer)MutantShulkerTurretCommonConfig.shulker_bullet_levitation_length.get();
                        shulkerBullet.levitationLevel = (Integer)MutantShulkerTurretCommonConfig.shulker_bullet_levitation_level.get();
                        shulkerBullet.m_6027_(this.m_20185_(), this.m_20186_() + (double)this.getTopHeadEyeHeight(), this.m_20189_());
                        this.f_19853_.m_7967_((Entity)shulkerBullet);
                        this.m_5496_(SoundEvents.f_12417_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    }
                    if (!this.m_142582_(this.getTopHeadTarget()) || this.m_20270_(this.getTopHeadTarget()) > 20.0f) {
                        --this.topHeadLoseTargetTime;
                    }
                    if (this.topHeadLoseTargetTime <= 0 || this.getTopHeadTarget() instanceof LivingEntity && ((LivingEntity)this.getTopHeadTarget()).m_21224_() || this.getTopHeadTarget().m_213877_() || this.getTopHeadTarget() instanceof LivingEntity && !this.m_6779_((LivingEntity)this.getTopHeadTarget())) {
                        this.setTopHeadTargetID(0);
                    }
                }
            }
            if (this.getMidHeadTarget() == null) {
                this.midHeadXRot = this.rotlerp(this.midHeadXRot, 0.0f, 10.0f);
                this.midHeadYRot = this.rotlerp(this.midHeadYRot, this.f_20883_, 10.0f);
                if (!this.f_19853_.f_46443_ && !(viableTargets = this.f_19853_.m_45971_(Mob.class, this.TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(this.m_21133_(Attributes.f_22277_), 6.0, this.m_21133_(Attributes.f_22277_)))).isEmpty() && this.f_19796_.m_188503_(20) == 0) {
                    this.midHeadLoseTargetTime = 60;
                    this.setMidHeadTargetID(((Mob)viableTargets.get(this.f_19796_.m_188503_(viableTargets.size()))).m_19879_());
                }
            } else {
                double d9 = this.m_20185_();
                d1 = this.m_20186_() + (double)this.getMidHeadEyeHeight();
                d3 = this.m_20189_();
                d4 = this.getMidHeadTarget().m_20185_() - d9;
                d5 = this.getMidHeadTarget().m_20188_() - d1;
                d6 = this.getMidHeadTarget().m_20189_() - d3;
                d7 = Math.sqrt(d4 * d4 + d6 * d6);
                f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                f1 = (float)(-(Mth.m_14136_((double)d5, (double)d7) * 57.2957763671875));
                this.midHeadXRot = this.rotlerp(this.midHeadXRot, f1, 40.0f);
                this.midHeadYRot = this.rotlerp(this.midHeadYRot, f, 10.0f);
                if (!this.f_19853_.f_46443_) {
                    if (this.midHeadShootCooldown <= 0) {
                        this.midHeadShootCooldown = this.shulkerBulletShootCooldownLength;
                        this.midSegmentShootAnimationTick = this.shootAnimationLength;
                        this.f_19853_.m_7605_((Entity)this, (byte)5);
                    }
                    if (this.midSegmentShootAnimationTick == this.shootAnimationActionPoint) {
                        shulkerBullet = new ShulkerBullet(this.f_19853_, (LivingEntity)this, this.getMidHeadTarget(), Direction.Axis.Y);
                        shulkerBullet.m_6027_(this.m_20185_(), this.m_20186_() + (double)this.getMidHeadEyeHeight(), this.m_20189_());
                        this.f_19853_.m_7967_((Entity)shulkerBullet);
                        this.m_5496_(SoundEvents.f_12417_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    }
                    if (!this.m_142582_(this.getMidHeadTarget()) || this.m_20270_(this.getMidHeadTarget()) > 20.0f) {
                        --this.midHeadLoseTargetTime;
                    }
                    if (this.midHeadLoseTargetTime <= 0 || this.getMidHeadTarget() instanceof LivingEntity && ((LivingEntity)this.getMidHeadTarget()).m_21224_() || this.getMidHeadTarget().m_213877_() || this.getMidHeadTarget() instanceof LivingEntity && !this.m_6779_((LivingEntity)this.getMidHeadTarget())) {
                        this.setMidHeadTargetID(0);
                    }
                }
            }
        }
    }

    private float rotlerp(float p_31443_, float p_31444_, float p_31445_) {
        float f = Mth.m_14177_((float)(p_31444_ - p_31443_));
        if (f > p_31445_) {
            f = p_31445_;
        }
        if (f < -p_31445_) {
            f = -p_31445_;
        }
        return p_31443_ + f;
    }

    public void shootMutantShulkerProjectile(float angle, BlockPos shootToPos, boolean aimForTarget) {
        MutantShulkerBullet projectile = new MutantShulkerBullet((EntityType<? extends MutantShulkerBullet>)((EntityType)EntityTypeInit.MUTANT_SHULKER_BULLET.get()), this.f_19853_);
        projectile.damage = ((Double)MutantShulkerTurretCommonConfig.mutant_shulker_bullet_damage.get()).floatValue();
        projectile.griefing = (Boolean)MutantShulkerTurretCommonConfig.mutant_shulker_bullet_griefing.get();
        projectile.griefingDropsBlocks = (Boolean)MutantShulkerTurretCommonConfig.mutant_shulker_bullet_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false;
        projectile.explosionSize = ((Double)MutantShulkerTurretCommonConfig.mutant_shulker_bullet_explosion_size.get()).floatValue();
        projectile.levitationLength = (Integer)MutantShulkerTurretCommonConfig.mutant_shulker_bullet_levitation_length.get();
        projectile.levitationLevel = (Integer)MutantShulkerTurretCommonConfig.mutant_shulker_bullet_levitation_level.get();
        if (aimForTarget && this.m_5448_() != null) {
            projectile.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            projectile.setTargetByID(this.m_5448_().m_19879_());
            projectile.m_5602_((Entity)this);
            this.shootMutantShulkerProjectile(this.m_5448_().m_20183_(), projectile, angle);
            this.f_19853_.m_7967_((Entity)projectile);
        } else {
            projectile.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            projectile.m_5602_((Entity)this);
            this.shootMutantShulkerProjectile(shootToPos, projectile, angle);
            this.f_19853_.m_7967_((Entity)projectile);
        }
    }

    public void shootMutantShulkerProjectile(BlockPos p_33275_, Projectile p_33277_, float p_33278_) {
        this.shootMutantShulkerProjectile((LivingEntity)this, p_33275_, p_33277_, p_33278_, 1.0f);
    }

    public void shootMutantShulkerProjectile(LivingEntity p_32323_, BlockPos p_32324_, Projectile p_32325_, float p_32326_, float p_32327_) {
        double d0 = (double)p_32324_.m_123341_() - p_32323_.m_20185_();
        double d1 = (double)p_32324_.m_123343_() - p_32323_.m_20189_();
        double d2 = Math.sqrt(d0 * d0 + d1 * d1);
        double d3 = (double)p_32324_.m_123342_() - p_32325_.m_20186_() + d2 * (double)0.2f;
        Vector3f vector3f = this.getProjectileShotVector(p_32323_, new Vec3(d0, d3, d1), p_32326_);
        p_32325_.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), p_32327_, (float)(14 - p_32323_.f_19853_.m_46791_().m_19028_() * 4));
        p_32323_.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_SHOOT.get(), 1.0f, 1.0f / (p_32323_.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public Vector3f getProjectileShotVector(LivingEntity p_32333_, Vec3 p_32334_, float p_32335_) {
        Vec3 vec3 = p_32334_.m_82541_();
        Vec3 vec31 = vec3.m_82537_(new Vec3(0.0, 0.0, 0.0));
        if (vec31.m_82556_() <= 1.0E-7) {
            vec31 = vec3.m_82537_(p_32333_.m_20289_(1.0f));
        }
        Quaternion quaternion = new Quaternion(new Vector3f(vec31), 90.0f, true);
        Vector3f vector3f = new Vector3f(vec3);
        vector3f.m_122251_(quaternion);
        Quaternion quaternion1 = new Quaternion(vector3f, p_32335_, true);
        Vector3f vector3f1 = new Vector3f(vec3);
        vector3f1.m_122251_(quaternion1);
        return vector3f1;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.topSegmentShootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 5) {
            this.midSegmentShootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 6) {
            this.bottomSegmentShootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 7) {
            this.deployAnimationTick = this.deployAnimationLength;
        } else if (p_28844_ == 8) {
            this.m_6710_(null);
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState topSegmentPredicate(AnimationEvent<E> event) {
        if (this.deployAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_deployed", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.topSegmentShootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_top_segment_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_top_segment_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState midSegmentPredicate(AnimationEvent<E> event) {
        if (this.deployAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_deployed", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.midSegmentShootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_mid_segment_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_mid_segment_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState bottomSegmentPredicate(AnimationEvent<E> event) {
        if (this.deployAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_deployed", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.bottomSegmentShootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_bottom_segment_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_turret_bottom_segment_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::topSegmentPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller1", 0.0f, this::midSegmentPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller2", 0.0f, this::bottomSegmentPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void tickDownAnimTimers() {
        if (this.topSegmentShootAnimationTick > 0) {
            --this.topSegmentShootAnimationTick;
        }
        if (this.midSegmentShootAnimationTick > 0) {
            --this.midSegmentShootAnimationTick;
        }
        if (this.bottomSegmentShootAnimationTick > 0) {
            --this.bottomSegmentShootAnimationTick;
        }
        if (this.deployAnimationTick > 0) {
            --this.deployAnimationTick;
        }
    }

    class ShootAttackGoal
    extends Goal {
        public MutantShulkerTurret mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public ShootAttackGoal(MutantShulkerTurret mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.mob.deployAnimationTick <= 0 && this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.mob.f_19797_ >= this.nextUseTime && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.nextUseTime = this.mob.f_19797_ + this.mob.shulkerBulletShootCooldownLength;
            this.mob.bottomSegmentShootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)6);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target != null && this.mob.bottomSegmentShootAnimationTick == this.mob.shootAnimationActionPoint) {
                MutantShulkerTurret.this.shootMutantShulkerProjectile(0.0f, null, true);
            }
        }

        public boolean animationsUseable() {
            return this.mob.bottomSegmentShootAnimationTick <= 0;
        }
    }

    public class MutantShulkerTurretBodyRotationControl
    extends BodyRotationControl
    implements Control {
        private final Mob mob;
        private int headStableTime;
        private float lastStableYHeadRot;

        public MutantShulkerTurretBodyRotationControl(Mob p_24879_) {
            super(p_24879_);
            this.mob = p_24879_;
        }

        public void m_8121_() {
            if (this.isMoving()) {
                this.mob.f_20883_ = this.mob.m_146908_();
                this.rotateHeadIfNecessary();
                this.lastStableYHeadRot = this.mob.f_20885_;
                this.headStableTime = 0;
            } else if (this.notCarryingMobPassengers()) {
                if (Math.abs(this.mob.f_20885_ - this.lastStableYHeadRot) > 15.0f) {
                    this.headStableTime = 0;
                    this.lastStableYHeadRot = this.mob.f_20885_;
                    this.rotateBodyIfNecessary();
                } else {
                    ++this.headStableTime;
                    if (this.headStableTime > 10) {
                        this.rotateHeadTowardsFront();
                    }
                }
            }
        }

        private void rotateBodyIfNecessary() {
            if (this.mob instanceof MutantShulker && ((MutantShulker)this.mob).shouldBodyMoveWithHead()) {
                this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)75.0f);
            }
        }

        private void rotateHeadIfNecessary() {
            if (this.mob instanceof MutantShulker && ((MutantShulker)this.mob).shouldBodyMoveWithHead()) {
                this.mob.f_20885_ = Mth.m_14094_((float)this.mob.f_20885_, (float)this.mob.f_20883_, (float)75.0f);
            }
        }

        private void rotateHeadTowardsFront() {
            if (this.mob instanceof MutantShulker && ((MutantShulker)this.mob).shouldBodyMoveWithHead()) {
                int i = this.headStableTime - 10;
                float f = Mth.m_14036_((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
                float f1 = 75.0f * (1.0f - f);
                this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)f1);
            }
        }

        private boolean notCarryingMobPassengers() {
            return !(this.mob.m_146895_() instanceof Mob);
        }

        private boolean isMoving() {
            double d1;
            double d0 = this.mob.m_20185_() - this.mob.f_19854_;
            return d0 * d0 + (d1 = this.mob.m_20189_() - this.mob.f_19856_) * d1 > 2.500000277905201E-7;
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float p_28900_) {
            this.fraction = p_28900_;
        }

        public static Crackiness byFraction(float p_28902_) {
            for (Crackiness irongolem$crackiness : BY_DAMAGE) {
                if (!(p_28902_ < irongolem$crackiness.fraction)) continue;
                return irongolem$crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

